using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class REFERRALDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public REFERRALDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public REFERRAL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REFERRAL GetItemByPatientIcn(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string PatientIcn)
        {
            REFERRAL objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitemByPatientIcn(CURRENT_USER, CURRENT_REGISTRY_ID, PatientIcn).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REFERRAL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REFERRAL> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;           
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REFERRAL objSave)
        {
            Int32? objReturn = objSave.REFERRAL_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_save(CURRENT_USER, 
                        CURRENT_REGISTRY_ID, 
                        objSave.COMMENT_TEXT,
                        DateTime.Now, 
                        objSave.CREATEDBY, 
                        objSave.CREATEDSOURCE, 
                        objSave.DUPLICATE_FLAG, 
                        objSave.PATIENT_ID, 
                        objSave.PROVIDER_ID, 
                        objSave.REFERRAL_CLASS_TEXT,
                        objSave.REFERRAL_DATE, 
                        ref objReturn, 
                        objSave.REVIEW_BY, 
                        objSave.REVIEW_DATE, 
                        objSave.STD_REFERRALSTS_ID, 
                        objSave.STD_REGISTRY_ID, 
                        objSave.STD_REMINDERCLASS_ID,
                        DateTime.Now, 
                        objSave.UPDATEDBY, 
                        objSave.UPDATEDSOURCE);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_delete(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REFERRAL GetItemComplete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            REFERRAL objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    if (objReturn != null)
                    {
                        if (objReturn.STD_REGISTRY_ID > 0)
                            objReturn.STD_REGISTRY = dbContext.usp_STD_REGISTRY_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_REGISTRY_ID).FirstOrDefault();

                        if (objReturn.PATIENT_ID > 0)
                        {
                            objReturn.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.PATIENT_ID).FirstOrDefault();
                            objReturn.SPATIENT = dbContext.usp_SPATIENT_getitemByICN(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.PATIENT.PatientICN).FirstOrDefault();
                        }

                        if (objReturn.STD_REFERRALSTS_ID > 0)
                            objReturn.STD_REFERRALSTS = dbContext.usp_STD_REFERRALSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_REFERRALSTS_ID).FirstOrDefault();

                        if (objReturn.PROVIDER_ID > 0)
                            objReturn.SStaff_SStaff = dbContext.usp_SStaff_SStaff_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.PROVIDER_ID).FirstOrDefault();
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REFERRAL> GetItemsByRegistryStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_REFERRALSTS_ID)
        {
            List<REFERRAL> objReturn = null;
            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitemsByRegistryStatus(CURRENT_USER, CURRENT_REGISTRY_ID, STD_REFERRALSTS_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public List<REFERRALcommon> GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        public List<REFERRALcommon> GetItemsCommonByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<REFERRALcommon> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    //objReturn = dbContext.usp_REFERRAL_getitemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS).ToList();
                    objReturn = dbContext.usp_REFERRAL_getitemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REFERRALcommon> GetItemsCommonByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            List<REFERRALcommon> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitemsByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<REFERRALcommon> GetItemsCommonByProvider(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PROVIDER_ID)
        {
            List<REFERRALcommon> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitemsByProvider(CURRENT_USER, CURRENT_REGISTRY_ID, PROVIDER_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public REFERRAL GetItemByRegistryPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            REFERRAL objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REFERRAL_getitemByRegistryPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 SaveManual(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID, Int32 PROVIDER_ID)
        {
            Int32? objReturn = 0;

            try
            {
                Int32? providerId = null;
                if (providerId > 0) providerId = PROVIDER_ID;

                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_saveManual(CURRENT_USER, 
                        CURRENT_REGISTRY_ID, 
                        PATIENT_ID, 
                        providerId, 
                        ref objReturn);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, Int32 STD_REFERRALSTS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_REFERRAL_updateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, STD_REFERRALSTS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
